/*
 * NOTE:
 * Before you use this file, you must set a supported operating
 * system constant.  Search on SYSTEM to find the list of supported
 * constants and how to set the appropriate one.
 */


/*
 * This file is organized as follows:
 *  - product specific preprocessor directives that must be before all
 *    other declarations
 *  - Base CPI-C constants and type definitions
 *  - Base CPI-C function prototypes
 *  - Product specific constants and type definitions (enclosed in #if/#endif)
 *  - Product specific function prototypes (enclosed in #if/#endif)
 */

#ifndef _cpic_h
#define _cpic_h

/*
 * SYSTEM should be changed in the following #define
 * to an appropriate value for your platform.
 * The following values are handled by this file:
 *    CM_AIX
 *    CM_DOS
 *    CM_MVS
 *    CM_OS2
 *    CM_OS400
 *    CM_VM
 *
 * This is necessary for the proper setting of
 * CM_ENTRY and CM_PTR below.
 */


#if ! ( defined(CM_AIX)   || \
        defined(CM_DOS)   || \
        defined(CM_MVS)   || \
        defined(CM_OS2)   || \
        defined(CM_OS400) || \
        defined(CM_VM)       \
      )
/*
 * Define the system ONLY if no system has been defined by the program.
 * This avoids duplicate macro definition warnings and allows this
 * include file to be moved to other platforms easier.
 *
 * If you choose to move this include file to another platform,
 * we recommend that you define the CM_ constant for that platform
 * externally on the compiler command line.
 */

#define SYSTEM

#endif


/*
 * CPI Communications Enumerated Constants
 */

/*
 * CM_INT32 should be a 32-bit, signed integer.  The following #define
 * is system dependent and may need to be changed on systems where
 * signed long int does not define a 32-bit, signed integer.
 */

#define CM_INT32 signed long int


                       /* PWA Borland C++ for OS/2 support added */
                       /* as described in Schwaller's append in C++BCOS2 */
#ifdef   CM_OS2
#ifdef   __32BIT__
#ifndef  __BORLANDC__  /* PWA */
#ifndef  ES32TO16
#define  ES32TO16
#endif
#endif                 /* PWA */
#endif
#endif

#if   defined( CM_DOS ) || defined( CM_OS2 )

#ifndef __BORLANDC__                             /* PWA */
#     define CM_ENTRY extern void pascal far _loadds
#     define CM_PTR far *
#else                                            /* PWA */
#     define CM_ENTRY extern void pascal _far16  /* PWA */
#     define CM_PTR _far16 *                     /* PWA */
#endif                                           /* PWA */

#elif defined( CM_MVS ) || defined( CM_OS400 ) || \
      defined( CM_VM )  || defined( AIX )

#     define CM_ENTRY extern void
#     define CM_PTR *

#else

/*
 * If we have gotten this far, a supported system constant has not
 * been defined.  We will produce a syntax error on the next line
 * that should help the user identify the problem.
 *
 * To correct this problem, a system constant should be defined
 * either above in this file, or externally with a compiler option.
 */
/*
 * These lint comments allow lint to bypass the following line, which,
 * although illegal, is meant to be that way.
 */
INTENTIONAL_SYNTAX_ERROR define_a_system_in_cpic_h();

#endif



#ifdef ES32TO16

/*
 * The IBM C Set/2 32 bit compiler for OS/2 2.0 requires different
 * definitions for entry points, pointers, and structures.
 * These definitions help the compiler perform the translations from
 * 32bit addresses to segmented addresses.
 */

#   ifdef CM_PTR
#      undef CM_PTR
#   endif
#   ifdef CM_ENTRY
#      undef CM_ENTRY
#   endif
#   ifdef CM_INT32
#      undef CM_INT32
#   endif
# define CM_PTR * _Seg16
# define CM_ENTRY extern void
# define CM_INT32 signed int

# define STRUCT16 _Packed struct
# pragma seg16(SIDE_INFO)
#else
# define STRUCT16 struct
#endif

#if defined(CM_OS400) || defined(CM_MVS)
#define cmacci   CMACCI
#define cmaccp   CMACCP
#define cmallc   CMALLC
#define cmcanc   CMCANC
#define cmcfm    CMCFM
#define cmcfmd   CMCFMD
#define cmcnvi   CMCNVI
#define cmcnvo   CMCNVO
#define cmdeal   CMDEAL
#define cmecs    CMECS
#define cmect    CMECT
#define cmembs   CMEMBS
#define cmemn    CMEMN
#define cmepln   CMEPLN
#define cmesl    CMESL
#define cmesrm   CMESRM
#define cmetpn   CMETPN
#define cmflus   CMFLUS
#define cminic   CMINIC
#define cminit   CMINIT
#define cmptr    CMPTR
#define cmrcv    CMRCV
#define cmrcvx   CMRCVX
#define cmrltp   CMRLTP
#define cmrts    CMRTS
#define cmsct    CMSCT
#define cmsdt    CMSDT
#define cmsed    CMSED
#define cmsend   CMSEND
#define cmserr   CMSERR
#define cmsf     CMSF
#define cmsld    CMSLD
#define cmsltp   CMSLTP
#define cmsmn    CMSMN
#define cmsndx   CMSNDX
#define cmspln   CMSPLN
#define cmspm    CMSPM
#define cmsptr   CMSPTR
#define cmsqcf   CMSQCF
#define cmsqpm   CMSQPM
#define cmsrc    CMSRC
#define cmsrt    CMSRT
#define cmssl    CMSSL
#define cmssrm   CMSSRM
#define cmsst    CMSST
#define cmstpn   CMSTPN
#define cmtrace  CMTRACE
#define cmtrts   CMTRTS
#define cmwait   CMWAIT
#define cmwcmp   CMWCMP
#define cpicinit CPICINIT
#define cpickit  CPICKIT
#define cpicutil CPICUTIL
#define genprobe GENPROBE
#define xcccmp   XCCCMP
#define xcqfdx   XCQFDX
#define xcecst   XCECST
#define xcecsu   XCECSU
#define xcellu   XCELLU
#define xcesrc   XCESRC
#define xceti    XCETI
#define xcmesi   XCMESI
#define xcmssi   XCMSSI
#define cmscsp   CMSCSP
#define cmscst   CMSCST
#define cmscsu   CMSCSU
#define xcsllu   XCSLLU
#define xcstp    XCSTP
#define xcendt   XCENDT
#define xcinct   XCINCT
#define cmectx   CMECTX
#endif



/*
 *  - Base CPI-C constants and type definitions
 */

typedef unsigned char CM_CONVERSATION_ID[ 8 ];   /* conversation ID */
typedef unsigned char CM_USER_FIELD[ 8 ];        /* user field data */
typedef unsigned char CM_CALLBACK_FUNCTION[ 8 ]; /* callback function data */
typedef unsigned char CM_CALLBACK_INFO[ 8 ];     /* callback info data */
typedef unsigned char XC_CPIC_TP_ID[ 12 ];       /* cpic TP ID (for XC calls)*/

typedef CM_INT32 CM_CONVERSATION_STATE;
typedef CM_INT32 CM_CONVERSATION_TYPE;
typedef CM_INT32 CM_DATA_RECEIVED_TYPE;
typedef CM_INT32 CM_DEALLOCATE_TYPE;
typedef CM_INT32 CM_ERROR_DIRECTION;
typedef CM_INT32 CM_FILL;
typedef CM_INT32 CM_PREPARE_TO_RECEIVE_TYPE;
typedef CM_INT32 CM_RECEIVE_TYPE;
typedef CM_INT32 CM_REQUEST_TO_SEND_RECEIVED;
typedef CM_INT32 CM_RETURN_CODE;
typedef CM_INT32 CM_RETURN_CONTROL;
typedef CM_INT32 CM_SEND_TYPE;
typedef CM_INT32 CM_STATUS_RECEIVED;
typedef CM_INT32 CM_SYNC_LEVEL;
typedef CM_INT32 CM_TP_END_TYPE;
typedef CM_INT32 CM_CONVERSATION_SECURITY_TYPE;

typedef CM_INT32 CM_CONVERSATION_QUEUE;
typedef CM_INT32 CM_OUTSTANDING_OP_ID;
typedef CM_INT32 CM_PROCESSING_MODE;
typedef CM_INT32 CM_SEND_RECEIVE_MODE;

typedef CM_INT32 CM_SECONDARY_RETURN_CODE;

/*  conversation_state values  */
#define CM_INITIALIZE_STATE              (CM_CONVERSATION_STATE) 2
#define CM_SEND_STATE                    (CM_CONVERSATION_STATE) 3
#define CM_RECEIVE_STATE                 (CM_CONVERSATION_STATE) 4
#define CM_SEND_PENDING_STATE            (CM_CONVERSATION_STATE) 5
#define CM_CONFIRM_STATE                 (CM_CONVERSATION_STATE) 6
#define CM_CONFIRM_SEND_STATE            (CM_CONVERSATION_STATE) 7
#define CM_CONFIRM_DEALLOCATE_STATE      (CM_CONVERSATION_STATE) 8
/*
 * The following conversation state values only occur in a conversation
 * having a sync_level of CM_SYNC_POINT
 */
#define CM_DEFER_RECEIVE_STATE           (CM_CONVERSATION_STATE) 9
#define CM_DEFER_DEALLOCATE_STATE        (CM_CONVERSATION_STATE) 10
#define CM_SYNC_POINT_STATE              (CM_CONVERSATION_STATE) 11
#define CM_SYNC_POINT_SEND_STATE         (CM_CONVERSATION_STATE) 12
#define CM_SYNC_POINT_DEALLOCATE_STATE   (CM_CONVERSATION_STATE) 13

/* CPIC 1.2 */
#define CM_INITIALIZE_INCOMING_STATE     (CM_CONVERSATION_STATE) 14

/* CPIC 2.0 */
#define CM_SEND_ONLY_STATE               (CM_CONVERSATION_STATE) 15
#define CM_RECEIVE_ONLY_STATE            (CM_CONVERSATION_STATE) 16
#define CM_SEND_RECEIVE_STATE            (CM_CONVERSATION_STATE) 17





/*  conversation_queue values  */
#define CM_INITIALIZATION_QUEUE          (CM_CONVERSATION_QUEUE) 0
#define CM_SEND_QUEUE                    (CM_CONVERSATION_QUEUE) 1
#define CM_RECEIVE_QUEUE                 (CM_CONVERSATION_QUEUE) 2
#define CM_SEND_RECEIVE_QUEUE            (CM_CONVERSATION_QUEUE) 3
#define CM_EXPEDITED_SEND_QUEUE          (CM_CONVERSATION_QUEUE) 4
#define CM_EXPEDITED_RECEIVE_QUEUE       (CM_CONVERSATION_QUEUE) 5

/*  conversation_type values  */
#define CM_BASIC_CONVERSATION            (CM_CONVERSATION_TYPE) 0
#define CM_MAPPED_CONVERSATION           (CM_CONVERSATION_TYPE) 1

/*  data_received values  */
#define CM_NO_DATA_RECEIVED              (CM_DATA_RECEIVED_TYPE) 0
#define CM_DATA_RECEIVED                 (CM_DATA_RECEIVED_TYPE) 1
#define CM_COMPLETE_DATA_RECEIVED        (CM_DATA_RECEIVED_TYPE) 2
#define CM_INCOMPLETE_DATA_RECEIVED      (CM_DATA_RECEIVED_TYPE) 3

/*  deallocate_type values  */
#define CM_DEALLOCATE_SYNC_LEVEL         (CM_DEALLOCATE_TYPE) 0
#define CM_DEALLOCATE_FLUSH              (CM_DEALLOCATE_TYPE) 1
#define CM_DEALLOCATE_CONFIRM            (CM_DEALLOCATE_TYPE) 2
#define CM_DEALLOCATE_ABEND              (CM_DEALLOCATE_TYPE) 3

/*  error_direction values  */
#define CM_RECEIVE_ERROR                 (CM_ERROR_DIRECTION) 0
#define CM_SEND_ERROR                    (CM_ERROR_DIRECTION) 1

/*  fill values  */
#define CM_FILL_LL                       (CM_FILL) 0
#define CM_FILL_BUFFER                   (CM_FILL) 1

/*  tp ended values  */
#define XC_SOFT                          (CM_TP_END_TYPE) 0
#define XC_HARD                          (CM_TP_END_TYPE) 1


/*  prepare_to_receive_type values  */
#define CM_PREP_TO_RECEIVE_SYNC_LEVEL    (CM_PREPARE_TO_RECEIVE_TYPE) 0
#define CM_PREP_TO_RECEIVE_FLUSH         (CM_PREPARE_TO_RECEIVE_TYPE) 1
#define CM_PREP_TO_RECEIVE_CONFIRM       (CM_PREPARE_TO_RECEIVE_TYPE) 2

/*  receive_type values  */
#define CM_RECEIVE_AND_WAIT              (CM_RECEIVE_TYPE) 0
#define CM_RECEIVE_IMMEDIATE             (CM_RECEIVE_TYPE) 1

/*  request_to_send_received values  */
#define CM_REQ_TO_SEND_NOT_RECEIVED      (CM_REQUEST_TO_SEND_RECEIVED) 0
#define CM_REQ_TO_SEND_RECEIVED          (CM_REQUEST_TO_SEND_RECEIVED) 1

/*  return_code values  */
#define CM_OK                            (CM_RETURN_CODE) 0
#define CM_ALLOCATE_FAILURE_NO_RETRY     (CM_RETURN_CODE) 1
#define CM_ALLOCATE_FAILURE_RETRY        (CM_RETURN_CODE) 2
#define CM_CONVERSATION_TYPE_MISMATCH    (CM_RETURN_CODE) 3
#define CM_PIP_NOT_SPECIFIED_CORRECTLY   (CM_RETURN_CODE) 5
#define CM_SECURITY_NOT_VALID            (CM_RETURN_CODE) 6
#define CM_SYNC_LVL_NOT_SUPPORTED_LU     (CM_RETURN_CODE) 7
#define CM_SYNC_LVL_NOT_SUPPORTED_PGM    (CM_RETURN_CODE) 8
#define CM_TPN_NOT_RECOGNIZED            (CM_RETURN_CODE) 9
#define CM_TP_NOT_AVAILABLE_NO_RETRY     (CM_RETURN_CODE) 10
#define CM_TP_NOT_AVAILABLE_RETRY        (CM_RETURN_CODE) 11
#define CM_DEALLOCATED_ABEND             (CM_RETURN_CODE) 17
#define CM_DEALLOCATED_NORMAL            (CM_RETURN_CODE) 18
#define CM_PARAMETER_ERROR               (CM_RETURN_CODE) 19
#define CM_PRODUCT_SPECIFIC_ERROR        (CM_RETURN_CODE) 20
#define CM_PROGRAM_ERROR_NO_TRUNC        (CM_RETURN_CODE) 21
#define CM_PROGRAM_ERROR_PURGING         (CM_RETURN_CODE) 22
#define CM_PROGRAM_ERROR_TRUNC           (CM_RETURN_CODE) 23
#define CM_PROGRAM_PARAMETER_CHECK       (CM_RETURN_CODE) 24
#define CM_PROGRAM_STATE_CHECK           (CM_RETURN_CODE) 25
#define CM_RESOURCE_FAILURE_NO_RETRY     (CM_RETURN_CODE) 26
#define CM_RESOURCE_FAILURE_RETRY        (CM_RETURN_CODE) 27
#define CM_UNSUCCESSFUL                  (CM_RETURN_CODE) 28
/* Watch this one! */
#define CM_TIMER_EXPIRED                 (CM_RETURN_CODE) 28
#define CM_DEALLOCATED_ABEND_SVC         (CM_RETURN_CODE) 30
#define CM_DEALLOCATED_ABEND_TIMER       (CM_RETURN_CODE) 31
#define CM_SVC_ERROR_NO_TRUNC            (CM_RETURN_CODE) 32
#define CM_SVC_ERROR_PURGING             (CM_RETURN_CODE) 33
#define CM_SVC_ERROR_TRUNC               (CM_RETURN_CODE) 34
#define CM_OPERATION_INCOMPLETE          (CM_RETURN_CODE) 35 /* CPIC 1.2 */
#define CM_SYSTEM_EVENT                  (CM_RETURN_CODE) 36 /* CPIC 1.2 */
#define CM_OPERATION_NOT_ACCEPTED        (CM_RETURN_CODE) 37 /* CPIC 1.2 */
#define CM_CONVERSATION_ENDING           (CM_RETURN_CODE) 38 /* CPIC 2? */
#define CM_SEND_RCV_MODE_NOT_SUPPORTED   (CM_RETURN_CODE) 39 /* CPIC 2 */
#define CM_BUFFER_PROVIDED_TOO_SMALL     (CM_RETURN_CODE) 40
#define CM_EXP_DATA_NOT_SUPPORTED        (CM_RETURN_CODE) 41
#define CM_NO_OUTSTANDING_OPERATION      (CM_RETURN_CODE) 42 /* CPIC 2 */

#define CM_CALL_NOT_APPLICABLE           (CM_RETURN_CODE) 44 /* CPIC 2 */
#define CM_RETRY_LIMIT_EXCEEDED          (CM_RETURN_CODE) 45 /* CPIC 2 */
#define CM_JOIN_PENDING                  (CM_RETURN_CODE) 46 /* CPIC 2 */
#define CM_NO_SECONDARY_INFORMATION      (CM_RETURN_CODE) 47 /* CPIC 2 */
#define CM_FUNCTION_NOT_SUPPORTED        (CM_RETURN_CODE) 48 /* CPIC 2 */

/* ECPIC-specific return code */
#define XC_OPERATION_CANCELLED           (CM_RETURN_CODE) 51

#define CM_TAKE_BACKOUT                  (CM_RETURN_CODE) 100
#define CM_DEALLOCATED_ABEND_BO          (CM_RETURN_CODE) 130
#define CM_DEALLOCATED_ABEND_SVC_BO      (CM_RETURN_CODE) 131
#define CM_DEALLOCATED_ABEND_TIMER_BO    (CM_RETURN_CODE) 132
#define CM_RESOURCE_FAIL_NO_RETRY_BO     (CM_RETURN_CODE) 133
#define CM_RESOURCE_FAILURE_RETRY_BO     (CM_RETURN_CODE) 134
#define CM_DEALLOCATED_NORMAL_BO         (CM_RETURN_CODE) 135
#define CM_CONV_DEALLOC_AFTER_SYNCPT     (CM_RETURN_CODE) 136 /* CPIC 2 */

/*  return_control values  */
#define CM_WHEN_SESSION_ALLOCATED        (CM_RETURN_CONTROL) 0
#define CM_IMMEDIATE                     (CM_RETURN_CONTROL) 1
#define CM_WHEN_SESSION_FREE             (CM_RETURN_CONTROL) 2
#define CM_WHEN_CONWINNER_ALLOC          (CM_RETURN_CONTROL) 3
#define CM_WHEN_CONV_GROUP_ALLOC         (CM_RETURN_CONTROL) 4

/*  send_type values  */
#define CM_BUFFER_DATA                   (CM_SEND_TYPE) 0
#define CM_SEND_AND_FLUSH                (CM_SEND_TYPE) 1
#define CM_SEND_AND_CONFIRM              (CM_SEND_TYPE) 2
#define CM_SEND_AND_PREP_TO_RECEIVE      (CM_SEND_TYPE) 3
#define CM_SEND_AND_DEALLOCATE           (CM_SEND_TYPE) 4

/*  status_received values  */
#define CM_NO_STATUS_RECEIVED            (CM_STATUS_RECEIVED) 0
#define CM_SEND_RECEIVED                 (CM_STATUS_RECEIVED) 1
#define CM_CONFIRM_RECEIVED              (CM_STATUS_RECEIVED) 2
#define CM_CONFIRM_SEND_RECEIVED         (CM_STATUS_RECEIVED) 3
#define CM_CONFIRM_DEALLOC_RECEIVED      (CM_STATUS_RECEIVED) 4
#define CM_TAKE_COMMIT                   (CM_STATUS_RECEIVED) 5
#define CM_TAKE_COMMIT_SEND              (CM_STATUS_RECEIVED) 6
#define CM_TAKE_COMMIT_DEALLOCATE        (CM_STATUS_RECEIVED) 7

/*  sync_level values  */
#define CM_NONE                          (CM_SYNC_LEVEL) 0
#define CM_CONFIRM                       (CM_SYNC_LEVEL) 1
#define CM_SYNC_POINT                    (CM_SYNC_LEVEL) 2

/*  conversation security types  */
#define CM_SECURITY_NONE                 (CM_CONVERSATION_SECURITY_TYPE) 0
#define CM_SECURITY_SAME                 (CM_CONVERSATION_SECURITY_TYPE) 1
#define CM_SECURITY_PROGRAM              (CM_CONVERSATION_SECURITY_TYPE) 2

/*  processing mode of conversation  */
#define CM_BLOCKING                      (CM_PROCESSING_MODE) 0
#define CM_NON_BLOCKING                  (CM_PROCESSING_MODE) 1
#define CM_ASYNCHRONOUS_NOTIFICATION     (CM_PROCESSING_MODE) 2

/*  send_receive_mode values  */
#define CM_HALF_DUPLEX                   (CM_SEND_RECEIVE_MODE) 0
#define CM_FULL_DUPLEX                   (CM_SEND_RECEIVE_MODE) 1
#define XC_FDX_OR_FDX_SIM                (CM_SEND_RECEIVE_MODE) 2




/****************************************************************************\
  ECPI-C specific declarations follow
\****************************************************************************/
/*
 * The XC_USER_FIELD is simply a data structure which facilitates the
 * use of the USER_FIELDS.
 */
typedef union {
    char bytes[ 8 ];                    /* simple 8-bytes */
    char CM_PTR ptr;                    /* pointer */
    CM_INT32 value;                     /* integer value */
} XC_USER_FIELD;

typedef unsigned char XC_QUERY_FULL_DUPLEX;
#define XC_LU_IS_FULL_DUPLEX     (XC_QUERY_FULL_DUPLEX)1
#define XC_LU_IS_NOT_FULL_DUPLEX (XC_QUERY_FULL_DUPLEX)0


/*  secondary return codes - these will be indices into a message file */
#define CM_FIRST_PARAMETER               (CM_SECONDARY_RETURN_CODE) 1
#define CM_SECOND_PARAMETER              (CM_SECONDARY_RETURN_CODE) 2
#define CM_THIRD_PARAMETER               (CM_SECONDARY_RETURN_CODE) 3
#define CM_FOURTH_PARAMETER              (CM_SECONDARY_RETURN_CODE) 4
#define CM_FIFTH_PARAMETER               (CM_SECONDARY_RETURN_CODE) 5
#define CM_SIXTH_PARAMETER               (CM_SECONDARY_RETURN_CODE) 6
#define CM_SEVENTH_PARAMETER             (CM_SECONDARY_RETURN_CODE) 7
#define CM_EIGHTH_PARAMETER              (CM_SECONDARY_RETURN_CODE) 8
#define CM_NINTH_PARAMETER               (CM_SECONDARY_RETURN_CODE) 9
#define CM_ENVIRONMENT_PARAMETER         (CM_SECONDARY_RETURN_CODE) 10
#define CM_BAD_CONV_ID                   (CM_SECONDARY_RETURN_CODE) 11


/*
 * X/open typedefs for compatabilty
 */
typedef CM_INT32 CONVERSATION_STATE;
typedef CM_INT32 CONVERSATION_TYPE;
typedef CM_INT32 DATA_RECEIVED_TYPE;
typedef CM_INT32 DEALLOCATE_TYPE;
typedef CM_INT32 ERROR_DIRECTION;
typedef CM_INT32 FILL;
typedef CM_INT32 PREPARE_TO_RECEIVE_TYPE;
typedef CM_INT32 RECEIVE_TYPE;
typedef CM_INT32 REQUEST_TO_SEND_RECEIVED;
typedef CM_INT32 CM_RETCODE;
typedef CM_INT32 RETURN_CONTROL;
typedef CM_INT32 SEND_TYPE;
typedef CM_INT32 STATUS_RECEIVED;
typedef CM_INT32 SYNC_LEVEL;
typedef CM_INT32 CONVERSAION_SECURITY_TYPE;
typedef CM_INT32 PROCESSING_MODE;

/*
 *  - Base CPI-C function prototypes
 */

/* TODO: need to add the X/OPEN calls */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

CM_ENTRY cmacci( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmaccp( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmallc( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmcanc( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmcfm ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* request_to_send_received */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmcfmd( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmcnvi( unsigned char CM_PTR,  /* input_buffer             */
                 CM_INT32 CM_PTR,       /* input_length             */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmcnvo( unsigned char CM_PTR,  /* input_buffer             */
                 CM_INT32 CM_PTR,       /* input_length             */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmdeal( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmecs ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* conversation_state       */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmect ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* conversation_type        */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmembs( CM_INT32 CM_PTR,       /* output_size              */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmemn ( unsigned char CM_PTR,  /* conversation_ID          */
                 unsigned char CM_PTR,  /* mode_name                */
                 CM_INT32 CM_PTR,       /* mode_name_length         */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmepln( unsigned char CM_PTR,  /* conversation_ID          */
                 unsigned char CM_PTR,  /* partner_LU_name          */
                 CM_INT32 CM_PTR,       /* partner_LU_name_length   */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmesl ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* sync_level               */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmesrm( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* send_receive_mode        */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmetpn( unsigned char CM_PTR,  /* conversation_ID          */
                 unsigned char CM_PTR,  /* tp name                  */
                 CM_INT32 CM_PTR,       /* tp name length           */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmflus( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cminic( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cminit( unsigned char CM_PTR,  /* conversation_ID          */
                 unsigned char CM_PTR,  /* sym_dest_name            */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmptr ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmrcv ( unsigned char CM_PTR,  /* conversation_ID          */
                 unsigned char CM_PTR,  /* buffer                   */
                 CM_INT32 CM_PTR,       /* requested_length         */
                 CM_INT32 CM_PTR,       /* data_received            */
                 CM_INT32 CM_PTR,       /* received_length          */
                 CM_INT32 CM_PTR,       /* status_received          */
                 CM_INT32 CM_PTR,       /* request_to_send_received */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmrcvx( unsigned char CM_PTR,  /* conversation_ID          */
                 unsigned char CM_PTR,  /* buffer                   */
                 CM_INT32 CM_PTR,       /* requested_length         */
                 CM_INT32 CM_PTR,       /* received_length          */
                 CM_INT32 CM_PTR,       /* request_to_send_received */
                 CM_INT32 CM_PTR,       /* exp_receive_type         */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmrltp( unsigned char CM_PTR,  /* tp name                  */
                 CM_INT32 CM_PTR,       /* tp name length           */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmrts ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsct ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* conversation_type        */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsdt ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* deallocate_type          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsed ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* error_direction          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsend( unsigned char CM_PTR,  /* conversation_ID          */
                 unsigned char CM_PTR,  /* buffer                   */
                 CM_INT32 CM_PTR,       /* send_length              */
                 CM_INT32 CM_PTR,       /* request_to_send_received */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmserr( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* request_to_send_received */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsf  ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* fill                     */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsld ( unsigned char CM_PTR,  /* conversation_ID          */
                 unsigned char CM_PTR,  /* log_data                 */
                 CM_INT32 CM_PTR,       /* log_data_length          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsltp( unsigned char CM_PTR,  /* tp name                  */
                 CM_INT32 CM_PTR,       /* tp name length           */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsmn ( unsigned char CM_PTR,  /* conversation_ID          */
                 unsigned char CM_PTR,  /* mode_name                */
                 CM_INT32 CM_PTR,       /* mode_name_length         */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsndx( unsigned char CM_PTR,  /* conversation_ID          */
                 unsigned char CM_PTR,  /* buffer                   */
                 CM_INT32 CM_PTR,       /* send_length              */
                 CM_INT32 CM_PTR,       /* request_to_send_received */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmspln( unsigned char CM_PTR,  /* conversation_ID          */
                 unsigned char CM_PTR,  /* partner_LU_name          */
                 CM_INT32 CM_PTR,       /* partner_LU_name_length   */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmspm ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* processing mode          */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsptr( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* prepare_to_receive_type  */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsqcf( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* conversation queue       */
                 void CM_PTR,           /* callback function        */
                 unsigned char CM_PTR,  /* user field               */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsqpm( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* conversation queue       */
                 CM_INT32 CM_PTR,       /* processing mode          */
                 unsigned char CM_PTR,  /* user field               */
                 CM_INT32 CM_PTR,       /* outstanding op id        */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsrc ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* return_control           */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsrt ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* receive_type             */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmssl ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* sync_level               */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmssrm( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* send_receive_mode        */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmsst ( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* send_type                */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmstpn( unsigned char CM_PTR,  /* conversation_ID          */
                 unsigned char CM_PTR,  /* TP_name                  */
                 CM_INT32 CM_PTR,       /* TP_name_length           */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmtrts( unsigned char CM_PTR,  /* conversation_ID          */
                 CM_INT32 CM_PTR,       /* request_to_send_received */
                 CM_INT32 CM_PTR );     /* return_code              */
CM_ENTRY cmwait( unsigned char CM_PTR,  /* output conversation ID   */
                 CM_INT32 CM_PTR,       /* output completed return code */
                 CM_INT32 CM_PTR );     /* output return code       */
CM_ENTRY cmwcmp( CM_INT32 CM_PTR,       /* input OOID list          */
                 CM_INT32 CM_PTR,       /* input number of OOID's   */
                 CM_INT32 CM_PTR,       /* input timeout value (microseconds)*/
                 CM_INT32 CM_PTR,       /* output OOID list         */
                 CM_INT32 CM_PTR,       /* output number of OOID's  */
                 CM_USER_FIELD CM_PTR,  /* output user field list   */
                 CM_INT32 CM_PTR );     /* output return_code       */
CM_ENTRY xcccmp( CM_INT32 CM_PTR,       /* input wait object list   */
                 CM_INT32 CM_PTR );     /* output return code       */

CM_ENTRY xcqfdx( unsigned char CM_PTR );/* is the LU full_duplex?   */

CM_ENTRY xcstp ( unsigned char CM_PTR,  /* LU alias                 */
                 CM_INT32 CM_PTR,       /* LU alias length          */
                 unsigned char CM_PTR,  /* TP name                  */
                 CM_INT32 CM_PTR,       /* TP name length           */
                 unsigned char CM_PTR,  /* CPI-C TP Id              */
                 CM_INT32 CM_PTR );     /* return code              */
CM_ENTRY xcinct( unsigned char CM_PTR,  /* output conv id           */
                 unsigned char CM_PTR,  /* sym dest name            */
                 unsigned char CM_PTR,  /* input tp id              */
                 CM_INT32 CM_PTR );     /* return code              */
CM_ENTRY xcendt( unsigned char CM_PTR,  /* input cpic tp id         */
                 CM_INT32 CM_PTR,       /* type (HARD,SOFT)         */
                 CM_INT32 CM_PTR );     /* return code              */
CM_ENTRY cmectx( unsigned char CM_PTR,  /* conversation_ID          */
                 unsigned char CM_PTR,  /* output context ID        */
                 CM_INT32 CM_PTR,       /* output context ID length */
                 CM_INT32 CM_PTR );     /* return_code              */


#if !defined(CM_DOS) /* extract calls are not supported in DOS */
CM_ENTRY xcecst( unsigned char  CM_PTR, /* conversation_ID            */
                 CM_INT32 CM_PTR,       /* conversation_security_type */
                 CM_INT32 CM_PTR );     /* return_code                */
CM_ENTRY xcecsu( unsigned char  CM_PTR, /* conversation_ID            */
                 unsigned char  CM_PTR, /* user_ID                    */
                 CM_INT32 CM_PTR,       /* user_ID_length             */
                 CM_INT32 CM_PTR );     /* return_code                */
#endif

CM_ENTRY xcellu( unsigned char CM_PTR,  /* conversation_ID              */
                 unsigned char CM_PTR,  /* output LU name               */
                 CM_INT32 CM_PTR,       /* output LU name length        */
                 CM_INT32 CM_PTR );     /* return code                  */
CM_ENTRY xcsllu( unsigned char CM_PTR,  /* conversation_ID              */
                 unsigned char CM_PTR,  /* LU name                      */
                 CM_INT32 CM_PTR,       /* LU name length               */
                 CM_INT32 CM_PTR );     /* return code                  */
CM_ENTRY xceti ( unsigned char CM_PTR,  /* conversation ID              */
                 unsigned char CM_PTR,  /* output TP id                 */
                 CM_INT32 CM_PTR );     /* return code                  */

/*
 * X/Open provides security calls in the base.
 * Since some SAA platforms already support the security calls through
 * product specific extensions, we'll provide macros here to help in
 * porting X/Open applications to these platforms.
 */
#if defined(CM_OS2) || defined(CM_VM) || defined(CM_DOS) || defined(CM_AIX)
#define cmscsu(v1,v2,v3,v4) xcscsu(v1,v2,v3,v4)
#define cmscsp(v1,v2,v3,v4) xcscsp(v1,v2,v3,v4)
#define cmscst(v1,v2,v3)    xcscst(v1,v2,v3)
#endif

#if defined(CM_OS2) || defined(CM_VM) || defined(CM_AIX)
/*
 * Networking Services/DOS does not provide extract security calls.
 */
#define cmecsu(v1,v2,v3,v4) xcecsu(v1,v2,v3,v4)   /* X/Open CPI-C */
#define cmesui(v1,v2,v3,v4) xcecsu(v1,v2,v3,v4)   /* CPI-C 1.2    */
#endif

#ifdef __cplusplus
}
#endif /* __cplusplus */


/*
 *  - Product specific constants and type definitions
 */
#if defined(CM_OS2) || defined(CM_DOS) || defined(CM_AIX)

/*
 * Conversation security extensions
 */
typedef CM_INT32 XC_CONVERSATION_SECURITY_TYPE;

/* conversation_security_type values */

#define XC_SECURITY_NONE                 (XC_CONVERSATION_SECURITY_TYPE) 0
#define XC_SECURITY_SAME                 (XC_CONVERSATION_SECURITY_TYPE) 1
#define XC_SECURITY_PROGRAM              (XC_CONVERSATION_SECURITY_TYPE) 2

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Set_Conversation_Security_Password */
CM_ENTRY xcscsp(unsigned char  CM_PTR,   /* conversation_ID                 */
                unsigned char  CM_PTR,   /* password                        */
                CM_INT32 CM_PTR,         /* password_length                 */
                CM_INT32 CM_PTR );        /* return_code                     */

/* Set_Conversation_Security_Type */
CM_ENTRY xcscst(unsigned char  CM_PTR,   /* conversation_ID                 */
                CM_INT32 CM_PTR,         /* conversation_security_type      */
                CM_INT32 CM_PTR );        /* return_code                     */

/* Set_Conversation_Security_User_ID */
CM_ENTRY xcscsu(unsigned char  CM_PTR,   /* conversation_ID                 */
                unsigned char  CM_PTR,   /* user_ID                         */
                CM_INT32 CM_PTR,         /* user_ID_length                  */
                CM_INT32 CM_PTR );        /* return_code                     */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif


#if defined(CM_OS2)
/*
 * Constants and prototypes for OS/2 side information calls
 */

typedef CM_INT32 XC_TP_NAME_TYPE;
/* TP_name_type values */
#define XC_APPLICATION_TP        (XC_TP_NAME_TYPE) 0
#define XC_SNA_SERVICE_TP        (XC_TP_NAME_TYPE) 1

/* side info structure used by xcmssi to define side info */
typedef struct side_info_entry {
    unsigned char    sym_dest_name[8];    /* symbolic destination name    */
    unsigned char    partner_LU_name[17];
    unsigned char    reserved[3];         /* currently not used           */
    XC_TP_NAME_TYPE  TP_name_type;        /* set to XC_APPLICATION_TP     */
                                          /*     or XC_SNA_SERVICE_TP     */
    unsigned char    TP_name[64];
    unsigned char    mode_name[8];
    XC_CONVERSATION_SECURITY_TYPE
                     conversation_security_type;
                                          /* set to XC_SECURITY_NONE      */
                                          /*   or   XC_SECURITY_SAME      */
                                          /*   or   XC_SECURITY_PROGRAM   */
    unsigned char    security_user_ID[8];
    unsigned char    security_password[8];
} SIDE_INFO;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Set_CPIC_Side_Information */
CM_ENTRY xcmssi(unsigned char CM_PTR,  /* key lock                          */
                SIDE_INFO CM_PTR,      /* side info_entry (see struct above)*/
                CM_INT32 CM_PTR,       /* side_info length                  */
                CM_INT32 CM_PTR );      /* return_code                       */

/* Extract_CPIC_Side_Information */
CM_ENTRY xcmesi(CM_INT32 CM_PTR,       /* entry_number                      */
                unsigned char CM_PTR,  /* symbolic destination name 8 chars */
                SIDE_INFO CM_PTR,      /* side_info_entry (see struct above)*/
                CM_INT32 CM_PTR,       /* side_info_length                  */
                CM_INT32 CM_PTR );      /* return_code                       */

/* TODO: Delete_CPIC_Side_Information */
CM_ENTRY xcmdsi(unsigned char CM_PTR,  /* key_lock                          */
                unsigned char CM_PTR,  /* symbolic destination name 8 chars */
                CM_INT32 CM_PTR );      /* return_code                       */
#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif

#ifdef CM_VM

/*
 * XC_INT32 should be a 32-bit, signed integer.  The following #define is
 * system dependent and may need to be changed on systems where signed long
 * int does not define a 32-bit, signed integer.
 */

#define XC_INT32 signed long int
#define XC_ENTRY extern void
#define XC_PTR *


typedef XC_INT32 CMINT;
typedef CMINT *PCMINT;
typedef unsigned char CMCHAR;
typedef CMCHAR *PCMCHAR;


typedef XC_INT32 XC_RESOURCE_MANAGER_TYPE;
/*  resource_manager_type values  */
#define XC_PRIVATE                    (XC_RESOURCE_MANAGER_TYPE) 0
#define XC_LOCAL                      (XC_RESOURCE_MANAGER_TYPE) 1
#define XC_GLOBAL                     (XC_RESOURCE_MANAGER_TYPE) 2
#define XC_SYSTEM                     (XC_RESOURCE_MANAGER_TYPE) 3

typedef XC_INT32 XC_SERVICE_MODE;
/*  service_mode values  */
#define XC_SINGLE                     (XC_SERVICE_MODE) 0
#define XC_SEQUENTIAL                 (XC_SERVICE_MODE) 1
#define XC_MULTIPLE                   (XC_SERVICE_MODE) 2

typedef XC_INT32 XC_SECURITY_LEVEL_FLAG;
/*  security_level_flag values  */
#define XC_REJECT_SECURITY_NONE       (XC_SECURITY_LEVEL_FLAG) 0
#define XC_ACCEPT_SECURITY_NONE       (XC_SECURITY_LEVEL_FLAG) 1

typedef XC_INT32 XC_CONVERSATION_SECURITY_TYPE;
/*  conversation_security_type values  */
#define XC_SECURITY_NONE              (XC_CONVERSATION_SECURITY_TYPE) 0
#define XC_SECURITY_SAME              (XC_CONVERSATION_SECURITY_TYPE) 1
#define XC_SECURITY_PROGRAM           (XC_CONVERSATION_SECURITY_TYPE) 2

typedef XC_INT32 XC_EVENT_TYPE;
/*  event_type values  */
#define XC_ALLOCATION_REQUEST         (XC_EVENT_TYPE) 1
#define XC_INFORMATION_INPUT          (XC_EVENT_TYPE) 2
#define XC_RESOURCE_REVOKED           (XC_EVENT_TYPE) 3
#define XC_CONSOLE_INPUT              (XC_EVENT_TYPE) 4
#define XC_REQUEST_ID                 (XC_EVENT_TYPE) 5
#define XC_USER_EVENT                 (XC_EVENT_TYPE) 6

CM_ENTRY xcecl( unsigned char CM_PTR,   /* conversation_ID          */
                unsigned char CM_PTR,   /* luwid                    */
                CM_INT32 CM_PTR,        /* luwid_length             */
                CM_INT32 CM_PTR );      /* return_code              */
CM_ENTRY xcecsu(unsigned char CM_PTR,   /* conversation_ID          */
                unsigned char CM_PTR,   /* security_user_ID         */
                CM_INT32 CM_PTR,        /* security_user_ID_length  */
                CM_INT32 CM_PTR );      /* return_code              */
CM_ENTRY xcecwu(unsigned char CM_PTR,   /* conversation_ID          */
                CM_INT32 CM_PTR,        /* workunitid               */
                CM_INT32 CM_PTR );      /* return_code              */
CM_ENTRY xcelfq(unsigned char CM_PTR,   /* conversation_ID          */
                unsigned char CM_PTR,   /* local_fq_LU_name         */
                CM_INT32 CM_PTR,        /* local_fq_LU_name_length  */
                CM_INT32 CM_PTR );      /* return_code              */
CM_ENTRY xcerfq(unsigned char CM_PTR,   /* conversation_ID          */
                unsigned char CM_PTR,   /* remote_fq_LU_name        */
                CM_INT32 CM_PTR,        /* remote_fq_LU_name_length */
                CM_INT32 CM_PTR );      /* return_code              */
CM_ENTRY xcetpn(unsigned char CM_PTR,   /* conversation_ID          */
                unsigned char CM_PTR,   /* TP_name                  */
                CM_INT32 CM_PTR,        /* TP_name_length           */
                CM_INT32 CM_PTR );      /* return_code              */
CM_ENTRY xcidrm(unsigned char CM_PTR,   /* resource_ID              */
                CM_INT32 CM_PTR,        /* resource_manager_type    */
                CM_INT32 CM_PTR,        /* service_mode             */
                CM_INT32 CM_PTR,        /* security_level_flag      */
                CM_INT32 CM_PTR );      /* return_code              */
CM_ENTRY xcscsp(unsigned char CM_PTR,   /* conversation_ID          */
                unsigned char CM_PTR,   /* security_password        */
                CM_INT32 CM_PTR,        /* security_password_length */
                CM_INT32 CM_PTR );      /* return_code              */
CM_ENTRY xcscst(unsigned char CM_PTR,   /* conversation_ID          */
                CM_INT32 CM_PTR,        /* conv_security_type       */
                CM_INT32 CM_PTR );      /* return_code              */
CM_ENTRY xcscsu(unsigned char CM_PTR,   /* conversation_ID          */
                unsigned char CM_PTR,   /* security_user_ID         */
                CM_INT32 CM_PTR,        /* security_user_ID_length  */
                CM_INT32 CM_PTR );      /* return_code              */
CM_ENTRY xcscui(unsigned char CM_PTR,   /* conversation_ID          */
                unsigned char CM_PTR,   /* client_user_ID           */
                CM_INT32 CM_PTR );      /* return_code              */
CM_ENTRY xcsue( unsigned char CM_PTR,   /* event_ID                 */
                unsigned char CM_PTR,   /* user_data                */
                CM_INT32 CM_PTR,        /* user_data_length         */
                CM_INT32 CM_PTR );      /* return_code              */
CM_ENTRY xctrrm(unsigned char CM_PTR,   /* resource_ID              */
                CM_INT32 CM_PTR );      /* return_code              */
CM_ENTRY xcwoe( unsigned char CM_PTR,   /* resource_ID              */
                unsigned char CM_PTR,   /* conversation_ID          */
                CM_INT32 CM_PTR,        /* event_type               */
                CM_INT32 CM_PTR,        /* info_input_length        */
                unsigned char CM_PTR,   /* console_input_buffer     */
                CM_INT32 CM_PTR );      /* return_code              */
#endif



/*
 *    #pragma linkage directives
 *
 * Note: For OS/400, routine names must be all uppercase.
 */
#if defined(CM_VM)
#     pragma linkage (cmaccp, OS)
#     pragma linkage (cmallc, OS)
#     pragma linkage (cmcfm,  OS)
#     pragma linkage (cmcfmd, OS)
#     pragma linkage (cmdeal, OS)
#     pragma linkage (cmecs,  OS)
#     pragma linkage (cmect,  OS)
#     pragma linkage (cmemn,  OS)
#     pragma linkage (cmepln, OS)
#     pragma linkage (cmesl,  OS)
#     pragma linkage (cmflus, OS)
#     pragma linkage (cminit, OS)
#     pragma linkage (cmptr,  OS)
#     pragma linkage (cmrcv,  OS)
#     pragma linkage (cmrts,  OS)
#     pragma linkage (cmsend, OS)
#     pragma linkage (cmserr, OS)
#     pragma linkage (cmsct,  OS)
#     pragma linkage (cmsdt,  OS)
#     pragma linkage (cmsed,  OS)
#     pragma linkage (cmsf,   OS)
#     pragma linkage (cmsld,  OS)
#     pragma linkage (cmsmn,  OS)
#     pragma linkage (cmspln, OS)
#     pragma linkage (cmsptr, OS)
#     pragma linkage (cmsrt,  OS)
#     pragma linkage (cmsrc,  OS)
#     pragma linkage (cmsst,  OS)
#     pragma linkage (cmssl,  OS)
#     pragma linkage (cmstpn, OS)
#     pragma linkage (cmtrts, OS)
#     pragma linkage (cmssrm, OS)
#     pragma linkage (cmesrm, OS)

#     pragma linkage (xcecl,  OS)
#     pragma linkage (xcecsu, OS)
#     pragma linkage (xcecwu, OS)
#     pragma linkage (xcelfq, OS)
#     pragma linkage (xcerfq, OS)
#     pragma linkage (xcetpn, OS)
#     pragma linkage (xcidrm, OS)
#     pragma linkage (xcscsp, OS)
#     pragma linkage (xcscst, OS)
#     pragma linkage (xcscsu, OS)
#     pragma linkage (xcscui, OS)
#     pragma linkage (xcsue,  OS)
#     pragma linkage (xctrrm, OS)
#     pragma linkage (xcwoe,  OS)
#     pragma linkage (xcqfdx, OS)
#     pragma linkage (cmectx, OS)
#endif

#if defined(CM_OS400) || defined(CM_MVS)
#     pragma linkage (CMACCP, OS)
#     pragma linkage (CMALLC, OS)
#     pragma linkage (CMCFM,  OS)
#     pragma linkage (CMCFMD, OS)
#     pragma linkage (CMDEAL, OS)
#     pragma linkage (CMECS,  OS)
#     pragma linkage (CMECT,  OS)
#     pragma linkage (CMEMN,  OS)
#     pragma linkage (CMEPLN, OS)
#     pragma linkage (CMESL,  OS)
#     pragma linkage (CMFLUS, OS)
#     pragma linkage (CMINIT, OS)
#     pragma linkage (CMPTR,  OS)
#     pragma linkage (CMRCV,  OS)
#     pragma linkage (CMRTS,  OS)
#     pragma linkage (CMSEND, OS)
#     pragma linkage (CMSERR, OS)
#     pragma linkage (CMSCT,  OS)
#     pragma linkage (CMSDT,  OS)
#     pragma linkage (CMSED,  OS)
#     pragma linkage (CMSF,   OS)
#     pragma linkage (CMSLD,  OS)
#     pragma linkage (CMSMN,  OS)
#     pragma linkage (CMSPLN, OS)
#     pragma linkage (CMSPTR, OS)
#     pragma linkage (CMSRT,  OS)
#     pragma linkage (CMSRC,  OS)
#     pragma linkage (CMSST,  OS)
#     pragma linkage (CMSSL,  OS)
#     pragma linkage (CMSTPN, OS)
#     pragma linkage (CMTRTS, OS)
#     pragme linkage (CMSSRM, OS)
#     pragma linkage (CMESRM, OS)
#     pragma linkage (CMECTX, OS)
/* TODO: Need to fill in all the new calls to migrate to other platforms */
#endif

/*
 *    #pragma linkage directives - use on OS/2 32 bit only
 */
#if defined(ES32TO16)
#     pragma linkage (cmaccp, far16 pascal)
#     pragma linkage (cmallc, far16 pascal)
#     pragma linkage (cmcfm,  far16 pascal)
#     pragma linkage (cmcfmd, far16 pascal)
#     pragma linkage (cmdeal, far16 pascal)
#     pragma linkage (cmecs,  far16 pascal)
#     pragma linkage (cmect,  far16 pascal)
#     pragma linkage (cmemn,  far16 pascal)
#     pragma linkage (cmepln, far16 pascal)
#     pragma linkage (cmesl,  far16 pascal)
#     pragma linkage (cmflus, far16 pascal)
#     pragma linkage (cminit, far16 pascal)
#     pragma linkage (cmptr,  far16 pascal)
#     pragma linkage (cmrcv,  far16 pascal)
#     pragma linkage (cmrts,  far16 pascal)
#     pragma linkage (cmsend, far16 pascal)
#     pragma linkage (cmserr, far16 pascal)
#     pragma linkage (cmsct,  far16 pascal)
#     pragma linkage (cmsdt,  far16 pascal)
#     pragma linkage (cmsed,  far16 pascal)
#     pragma linkage (cmsf,   far16 pascal)
#     pragma linkage (cmsld,  far16 pascal)
#     pragma linkage (cmsmn,  far16 pascal)
#     pragma linkage (cmspln, far16 pascal)
#     pragma linkage (cmsptr, far16 pascal)
#     pragma linkage (cmsrt,  far16 pascal)
#     pragma linkage (cmsrc,  far16 pascal)
#     pragma linkage (cmsst,  far16 pascal)
#     pragma linkage (cmssl,  far16 pascal)
#     pragma linkage (cmstpn, far16 pascal)
#     pragma linkage (cmtrts, far16 pascal)
#     pragma linkage (xcmssi, far16 pascal)
#     pragma linkage (xcmesi, far16 pascal)
#     pragma linkage (xcmdsi, far16 pascal)
#     pragma linkage (xcecst, far16 pascal)
#     pragma linkage (xcecsu, far16 pascal)
#     pragma linkage (xcscsp, far16 pascal)
#     pragma linkage (xcscst, far16 pascal)
#     pragma linkage (xcscsu, far16 pascal)
#     pragma linkage (cmspm,  far16 pascal)
#     pragma linkage (cmwait, far16 pascal)
#     pragma linkage (cmcanc, far16 pascal)
#     pragma linkage (cminic, far16 pascal)
#     pragma linkage (cmacci, far16 pascal)
#     pragma linkage (cmcnvi, far16 pascal)
#     pragma linkage (cmcnvo, far16 pascal)
#     pragma linkage (cmembs, far16 pascal)
#     pragma linkage (cmetpn, far16 pascal)
#     pragma linkage (cmsltp, far16 pascal)
#     pragma linkage (cmrltp, far16 pascal)
#     pragma linkage (cmwcmp, far16 pascal)
#     pragma linkage (cmsqcf, far16 pascal)
#     pragma linkage (cmsqpm, far16 pascal)
#     pragma linkage (xcqfdx, far16 pascal)
#     pragma linkage (cmssrm, far16 pascal)
#     pragma linkage (cmesrm, far16 pascal)
#     pragma linkage (xcccmp, far16 pascal)
#     pragma linkage (cmectx, far16 pascal)
#endif


/*
 * These macros allow you to write programs that are easier to read, since
 * you can use the full name of the CPI-C call rather than its 6 character
 * entry point.
 *
 * When porting code that uses these macros, you will have to ensure that
 * the macros are defined on the target platform.
 */
#ifdef READABLE_MACROS

#define Accept_Incoming(v1,v2)                cmacci(v1,v2)
#define Accept_Conversation(v1,v2)            cmaccp(v1,v2)
#define Allocate(v1,v2)                       cmallc(v1,v2)
#define Cancel_Conversation(v1,v2)            cmcanc(v1,v2)
#define Confirm(v1,v2,v3)                     cmcfm(v1,v2,v3)
#define Confirmed(v1,v2)                      cmcfmd(v1,v2)
#define Convert_Incoming(v1,v2,v3)            cmcnvi(v1,v2,v3)
#define Convert_Outgoing(v1,v2,v3)            cmcnvo(v1,v2,v3)
#define Deallocate(v1,v2)                     cmdeal(v1,v2)
#define Extract_Conversation_State(v1,v2,v3)  cmecs(v1,v2,v3)
#define Extract_Conversation_Type(v1,v2,v3)   cmect(v1,v2,v3)
#define Extract_Maximum_Buffer_Size(v1,v2)    cmembs(v1,v2)
#define Extract_Mode_Name(v1,v2,v3,v4)        cmemn(v1,v2,v3,v4)
#define Extract_Partner_LU_Name(v1,v2,v3,v4)  cmepln(v1,v2,v3,v4)
#define Extract_Sync_Level(v1,v2,v3)          cmesl(v1,v2,v3)
#define Extract_Send_Receive_Mode(v1,v2,v3)   cmesrm(v1,v2,v3)
#define Extract_TP_Name(v1,v2,v3,v4)          cmetpn(v1,v2,v3,v4)
#define Flush(v1,v2)                          cmflus(v1,v2)
#define Initialize_For_Incoming(v1,v2)            cminic(v1,v2)
#define Initialize_Conversation(v1,v2,v3)     cminit(v1,v2,v3)
#define Prepare_To_Receive(v1,v2)             cmptr(v1,v2)
#define Receive(v1,v2,v3,v4,v5,v6,v7,v8)      cmrcv(v1,v2,v3,v4,v5,v6,v7,v8)
#define Receive_Expedited_Data(v1,v2,v3,v4,v5,v6,v7) \
                                              cmrcvx(v1,v2,v3,v4,v5,v6,v7)
#define Release_Local_TP_Name(v1,v2,v3)       cmrltp(v1,v2,v3)
#define Request_To_Send(v1,v2)                cmrts(v1,v2)
#define Set_Conversation_Type(v1,v2,v3)       cmsct(v1,v2,v3)
#define Set_Deallocate_Type(v1,v2,v3)         cmsdt(v1,v2,v3)
#define Set_Error_Direction(v1,v2,v3)         cmsed(v1,v2,v3)
#define Send_Data(v1,v2,v3,v4,v5)             cmsend(v1,v2,v3,v4,v5)
#define Send_Error(v1,v2,v3)                  cmserr(v1,v2,v3)
#define Set_Fill(v1,v2,v3)                    cmsf(v1,v2,v3)
#define Set_Log_Data(v1,v2,v3,v4)             cmsld(v1,v2,v3,v4)
#define Specify_Local_TP_Name(v1,v2,v3)       cmsltp(v1,v2,v3)
#define Set_Mode_Name(v1,v2,v3,v4)            cmsmn(v1,v2,v3,v4)
#define Send_Expedited_Data(v1,v2,v3,v4,v5)   cmsndx(v1,v2,v3,v4,v5)
#define Set_Partner_LU_Name(v1,v2,v3,v4)      cmspln(v1,v2,v3,v4)
#define Set_Processing_Mode(v1,v2,v3)         cmspm(v1,v2,v3)
#define Set_Prepare_To_Receive_Type(v1,v2,v3) cmsptr(v1,v2,v3)
#define Set_Queue_Callback_Function(v1,v2,v3,v4,v5) cmsqcf(v1,v2,v3,v4,v5)
#define Set_Queue_Processing_Mode(v1,v2,v3,v4,v5,v6) cmsqpm(v1,v2,v3,v4,v5,v6)
#define Set_Return_Control(v1,v2,v3)          cmsrc(v1,v2,v3)
#define Set_Receive_Type(v1,v2,v3)            cmsrt(v1,v2,v3)
#define Set_Sync_Level(v1,v2,v3)              cmssl(v1,v2,v3)
#define Set_Send_Receive_Mode(v1,v2,v3)       cmssrm(v1,v2,v3)
#define Set_Send_Type(v1,v2,v3)               cmsst(v1,v2,v3)
#define Set_TP_Name(v1,v2,v3,v4)              cmstpn(v1,v2,v3,v4)
#define Test_Request_To_Send_Received(v1,v2,v3) cmtrts(v1,v2,v3)
#define Wait_For_Conversation(v1,v2,v3)       cmwait(v1,v2,v3)
#define Wait_For_Completion(v1,v2,v3,v4,v5,v6,v7) cmwcmp(v1,v2,v3,v4,v5,v6,v7)
#define Cancel_Wait_For_Completion(v1,v2)     xcccmp(v1,v2)
#define Extract_Conversation_Security_Type(v1,v2,v3) cmecst(v1,v2,v3)
#define Extract_Conversation_Security_User_ID(v1,v2,v3,v4)  cmecsu(v1,v2,v3,v4)
#define Extract_Local_LU(v1,v2,v3,v4)         xcellu(v1,v2,v3,v4)
#define Extract_TP_ID(v1,v2,v3)               xceti(v1,v2,v3)
#define Extract_CPIC_Side_Information(v1,v2,v3,v4,v5) xcmesi(v1,v2,v3,v4,v5)
#define Extract_Conversation_Context(v1,v2,v3,v4) cmectx(v1,v2,v3,v4)
#define Set_CPIC_Side_Information(v1,v2,v3,v4) xcmssi(v1,v2,v3,v4)
#define Set_Conversation_Security_Password(v1,v2,v3,v4) xcscsp(v1,v2,v3,v4)
#define Set_Conversation_Security_Type(v1,v2,v3) xcscst(v1,v2,v3)
#define Set_Conversation_Security_User_ID(v1,v2,v3,v4) xcscsu(v1,v2,v3,v4)
#define Set_Local_LU(v1,v2,v3,v4)             xcsllu(v1,v2,v3,v4)
#define Start_TP(v1,v2,v3,v4,v5,v6)           xcstp(v1,v2,v3,v4,v5,v6)
#define End_TP(v1,v2,v3)                      xcendt(v1,v2,v3)
#define Initialize_Conversation_for_TP(v1,v2,v3,v4) xcinct(v1,v2,v3,v4)
#endif /* READABLE_MACROS */

#endif /* _cpic_h */

